@extends('admin.layout.template')
@section('title', 'Add Role')
<style>
    .border {
        box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 12px;
    }
</style>
@section('content')

<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('roles.index')}}">Roles</a></li>
                <li class="breadcrumb-item active" aria-current="page">Add Roles</li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Add Role</h4>
            </div>

            <form method="POST" action="{{ route('roles.store') }}">
                @csrf

                <div class="card-body">
                    <div class="row">
                        <!-- Role Name -->
                        <div class="mb-4 col-md-6">
                            <label class="form-label">Role Name</label>
                            <input type="text" name="role_name" class="form-control" required>
                        </div>
                        <div class="mb-4 col-md-6">
                            <label class="form-label fw-semibold">Department</label>
                            <select name="department_ids[]" data-choices multiple id="department"
                                class="form-select" required>
                                <option value="">-- Select Department --</option>
                                @foreach(App\Models\Department::get() as $dept)
                                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <hr>

                    <!-- Permissions -->
                    @foreach($permissions as $module => $perms)
                    <div class="border rounded p-3 mb-3">

                        {{-- Module Header --}}
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h5 class="mb-0 text-capitalize">{{ str_replace(['-', '_'], ' ', $module) }}</h5>


                            <div>
                                <input type="checkbox"
                                    class="form-check-input select-all"
                                    data-module="{{ $module }}">
                                <label class="form-check-label">Select All</label>
                            </div>
                        </div>

                        {{-- Permissions Checkboxes --}}
                        <div class="row">
                            @foreach($perms as $permission)
                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="checkbox"
                                        class="form-check-input permission-checkbox module-{{ $module }}"
                                        name="permissions[]"
                                        value="{{ $permission }}"
                                        {{ in_array($permission, $rolePermissions) ? 'checked' : '' }}>

                                    <label class="form-check-label">
                                        {{ ucwords(str_replace(['.', '-'], ' ', $permission)) }}
                                    </label>
                                </div>
                            </div>
                            @endforeach
                        </div>

                        <hr>
                        <div class="row">
                            <div class="mt-3 col-md-6">
                                <label class="form-label">Data Access Scope</label>

                                <select name="scopes[{{ $module }}][scope_type]"
                                    class="form-select scope-type"
                                    data-module="{{ $module }}">
                                    <option value="all">All Data</option>
                                    <option value="assigned_location">Assigned Locations</option>
                                    <option value="assigned_franchise">Assigned Franchise</option>
                                    <option value="assigned_dealer">Assigned Dealer</option>
                                    <option value="assigned_projects">Assigned Projects</option>
                                    <option value="own_only">Own Records Only</option>
                                </select>
                            </div>


                            {{-- Assigned Locations --}}
                            <div class="mt-3 col-md-6 scope-value d-none"
                                id="scope-assigned_location-{{ $module }}">
                                <label class="form-label">Select Locations</label>
                                <select name="scopes[{{ $module }}][scope_value][]"
                                    class="form-select" data-choices
                                    multiple>
                                    @foreach(App\Models\Location::get() as $location)
                                    <option value="{{ $location->id }}">
                                        {{ $location->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Assigned Franchise --}}
                            <div class="mt-3 col-md-6 scope-value d-none"
                                id="scope-assigned_franchise-{{ $module }}">
                                <label class="form-label">Select Franchise</label>
                                <select name="scopes[{{ $module }}][scope_value][]"
                                    class="form-select" data-choices
                                    multiple>
                                    @foreach(App\Models\User::where('user_type','franchise')->get() as $franchise)
                                    <option value="{{ $franchise->id }}">
                                        {{ $franchise->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Assigned Dealer --}}
                            <div class="mt-3 col-md-6 scope-value d-none"
                                id="scope-assigned_dealer-{{ $module }}">
                                <label class="form-label">Select Dealers</label>
                                <select name="scopes[{{ $module }}][scope_value][]"
                                    class="form-select" data-choices
                                    multiple>
                                    @foreach(App\Models\User::where('user_type','dealer')->get() as $dealer)
                                    <option value="{{ $dealer->id }}">
                                        {{ $dealer->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            {{-- Assigned Projects --}}
                            <div class="mt-3 col-md-6 scope-value d-none"
                                id="scope-assigned_projects-{{ $module }}">
                                <label class="form-label">Select Projects</label>
                                <select name="scopes[{{ $module }}][scope_value][]"
                                    class="form-select" data-choices
                                    multiple>

                                </select>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    @if(auth()->user()->hasRole('Super Admin'))
                    <div class="form-check mt-4">
                        <input type="checkbox" class="form-check-input"
                            name="is_locked" value="1">
                        <label class="form-check-label fw-semibold">
                            Lock this role (System Role)
                        </label>
                    </div>
                    @endif

                </div>

                <div class="card-footer text-end">
                    <button type="submit" class="btn btn-primary">Save Role</button>
                </div>

            </form>
        </div>
    </div>
</div>

<script>
    document.querySelectorAll('.select-all').forEach(selectAll => {
        selectAll.addEventListener('change', function() {
            let module = this.dataset.module;
            let checkboxes = document.querySelectorAll('.module-' + module);

            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    });

    document.querySelectorAll('.scope-type').forEach(select => {
        select.addEventListener('change', function() {

            const module = this.dataset.module;
            const selected = this.value;

            // hide all scope_value blocks for this module
            document.querySelectorAll(
                `[id^="scope-"][id$="-${module}"]`
            ).forEach(el => el.classList.add('d-none'));

            // show selected scope_value block
            if (!['all', 'own_only'].includes(selected)) {
                const target = document.getElementById(
                    `scope-${selected}-${module}`
                );
                if (target) target.classList.remove('d-none');
            }
        });
    });
</script>


@endsection